/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluid {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final int tintColor;
    private final TintMethod tintMethod;
    private final List<Fluid> equivalentFluids;
    private final int luminosity;
    private final Map<Item, FilledContainerCategory> filledContainersMap;
    private final Item foodItem;
    private final int foodDivider;
    private final ResourceLocation id;
    private final String[] NBTFromItem;
    private final String translationKey;
    public final boolean isCustom;
    private final boolean disabled;
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;

    public SoftFluid(Builder builder) {
        this.stillTexture = builder.stillTexture;
        this.flowingTexture = builder.flowingTexture;
        this.tintColor = builder.tintColor;
        this.tintMethod = builder.tintMethod;
        this.equivalentFluids = builder.equivalentFluids;
        this.luminosity = builder.luminosity;
        this.filledContainersMap = builder.filledContainers;
        this.foodItem = builder.foodItem;
        this.foodDivider = Math.max(1, builder.foodDivider);
        this.id = builder.id;
        this.translationKey = builder.translationKey;
        this.NBTFromItem = builder.NBTFromItem;
        this.isCustom = builder.custom;
        this.disabled = builder.isDisabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public int getFoodDivider() {
        return this.foodDivider;
    }

    public Item getFoodItem() {
        return this.foodItem;
    }

    public TranslationTextComponent getTranslatedName() {
        return new TranslationTextComponent(this.translationKey);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getID() {
        return this.id.toString();
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public Fluid getForgeFluid() {
        Iterator<Fluid> iterator = this.equivalentFluids.iterator();
        if (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            return fluid;
        }
        return Fluids.field_204541_a;
    }

    public String[] getNbtKeyFromItem() {
        return this.NBTFromItem;
    }

    public List<Fluid> getEquivalentFluids() {
        return this.equivalentFluids;
    }

    public boolean isEquivalent(Fluid fluid) {
        return this.equivalentFluids.contains(fluid);
    }

    public boolean isEmpty() {
        return this == SoftFluidRegistry.EMPTY;
    }

    @Nullable
    public FilledContainerCategory tryGettingFilledItems(Item emptyContainer) {
        return this.filledContainersMap.get(emptyContainer);
    }

    @Nullable
    public Item tryGettingEmptyItem(Item filledContainer) {
        for (Item k : this.filledContainersMap.keySet()) {
            for (Item i : this.filledContainersMap.get(k).getItems()) {
                if (i != filledContainer) continue;
                return k;
            }
        }
        return null;
    }

    public List<Item> getAllFilledContainers() {
        ArrayList<Item> list = new ArrayList<Item>();
        this.getFilledContainersMap().values().forEach(c -> list.addAll(((FilledContainerCategory)c).filled));
        return list;
    }

    public Map<Item, FilledContainerCategory> getFilledContainersMap() {
        return this.filledContainersMap;
    }

    @Nullable
    public Item getFilledContainer(Item emptyContainer) {
        FilledContainerCategory c = this.filledContainersMap.get(emptyContainer);
        if (c != null && !c.isEmpty()) {
            return c.getFirstFilled();
        }
        return null;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return this.foodItem != Items.field_190931_a;
    }

    public static enum TintMethod {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

    }

    public static class FilledContainerCategory {
        private int containerCapacity;
        private SoundEvent fillSound;
        private SoundEvent emptySound;
        private final List<Item> filled = new ArrayList<Item>();

        public FilledContainerCategory(int containerCapacity, @Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
            this.containerCapacity = containerCapacity;
            this.fillSound = fillSound;
            this.emptySound = emptySound;
        }

        public FilledContainerCategory(int containerCapacity) {
            this(containerCapacity, SoundEvents.field_187615_H, SoundEvents.field_191241_J);
        }

        public void setCapacity(int containerCapacity) {
            this.containerCapacity = containerCapacity;
        }

        public int getCapacity() {
            return this.containerCapacity;
        }

        public void addItem(Item i) {
            if (!this.filled.contains(i)) {
                this.filled.add(i);
            }
        }

        public void setSounds(@Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
            this.emptySound = emptySound;
            this.fillSound = fillSound;
        }

        public int getAmount() {
            return this.containerCapacity;
        }

        @Nullable
        public SoundEvent getFillSound() {
            return this.fillSound;
        }

        @Nullable
        public SoundEvent getEmptySound() {
            return this.emptySound;
        }

        public List<Item> getItems() {
            return this.filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        @Nullable
        public Item getFirstFilled() {
            if (this.isEmpty()) {
                return null;
            }
            return this.filled.get(0);
        }
    }

    public static class Builder {
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        private String translationKey = "fluid.selene.generic_fluid";
        private String[] NBTFromItem = null;
        private int tintColor = -1;
        private TintMethod tintMethod = TintMethod.STILL_AND_FLOWING;
        private int luminosity = 0;
        private Item foodItem = Items.field_190931_a;
        private int foodDivider = 1;
        private ResourceLocation id;
        public boolean isDisabled = false;
        public boolean custom = true;
        private final List<Fluid> equivalentFluids = new ArrayList<Fluid>();
        private final Map<Item, FilledContainerCategory> filledContainers = new LinkedHashMap<Item, FilledContainerCategory>();

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation id) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.id = id;
            this.isDisabled = !ModList.get().isLoaded(id.func_110624_b());
        }

        public Builder(String stillTexture, String flowingTexture, String id) {
            this(new ResourceLocation(stillTexture), new ResourceLocation(flowingTexture), new ResourceLocation(id));
        }

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, String id) {
            this(stillTexture, flowingTexture, new ResourceLocation(id));
        }

        public Builder(Fluid fluid) {
            FluidAttributes att = fluid.getAttributes();
            this.stillTexture = att.getStillTexture();
            this.flowingTexture = att.getFlowingTexture();
            this.color(att.getColor());
            this.luminosity = att.getLuminosity();
            this.translationKey = att.getTranslationKey();
            this.addEqFluid(fluid);
            this.id = fluid.getRegistryName();
            this.isDisabled = false;
        }

        public Builder(String fluidRes) {
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes))) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes));
                if (fluid != null && fluid != Fluids.field_204541_a) {
                    FluidAttributes att = fluid.getAttributes();
                    this.stillTexture = att.getStillTexture(new FluidStack(fluid, 1));
                    this.flowingTexture = att.getFlowingTexture(new FluidStack(fluid, 1));
                    int color = att.getColor();
                    if (color == -1) {
                        this.tintMethod = TintMethod.NO_TINT;
                    }
                    this.color(color);
                    this.bucket(fluid.func_204524_b());
                    this.luminosity = att.getLuminosity();
                    this.translationKey = att.getTranslationKey();
                    this.addEqFluid(fluid);
                    this.id = fluid.getRegistryName();
                } else {
                    this.isDisabled = true;
                }
            } else {
                this.isDisabled = true;
            }
        }

        public final Builder textures(ResourceLocation still, ResourceLocation flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        public final Builder translationKey(String translationKey) {
            if (translationKey != null) {
                this.translationKey = translationKey;
            }
            return this;
        }

        public final Builder keepNBTFromItem(String ... NBTkey) {
            this.NBTFromItem = NBTkey;
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder noTint() {
            this.tintMethod = TintMethod.NO_TINT;
            return this;
        }

        public final Builder tinted() {
            this.tintMethod = TintMethod.STILL_AND_FLOWING;
            return this;
        }

        public final Builder onlyFlowingTinted() {
            this.tintMethod = TintMethod.FLOWING;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder addEqFluid(ResourceLocation fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(fluidRes) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidRes)) != null && f != Fluids.field_204541_a) {
                this.equivalentFluids.add(f);
                Item i = f.func_204524_b();
                if (i != Items.field_190931_a && i != Items.field_151133_ar) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder addEqFluid(String res) {
            return this.addEqFluid(new ResourceLocation(res));
        }

        public final Builder addEqFluid(Fluid fluid) {
            return this.addEqFluid(fluid.getRegistryName());
        }

        public final Builder copyFlowingTextureFrom(String fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes)) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes))) != null && f != Fluids.field_204541_a) {
                this.flowingTexture = f.getAttributes().getFlowingTexture();
            }
            return this;
        }

        public final Builder copyTexturesFrom(String fluidRes) {
            Fluid f;
            if (ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidRes)) && (f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidRes))) != null && f != Fluids.field_204541_a) {
                this.flowingTexture = f.getAttributes().getFlowingTexture();
                this.stillTexture = f.getAttributes().getStillTexture();
            }
            return this;
        }

        public final Builder fromMod(String modId) {
            boolean bl = this.isDisabled = !ModList.get().isLoaded(modId);
            if (this.id != null && !this.id.func_110624_b().equals(modId)) {
                this.id = new ResourceLocation(modId, this.id.func_110623_a());
            }
            return this;
        }

        public final Builder containerItem(Item filledItem, Item emptyItem, int itemCapacity) {
            if (filledItem != Items.field_190931_a) {
                FilledContainerCategory c = this.filledContainers.computeIfAbsent(emptyItem, s -> new FilledContainerCategory(itemCapacity));
                c.addItem(filledItem);
            }
            return this;
        }

        public final Builder containerItem(ResourceLocation filledItemRes, ResourceLocation emptyItemRes, int itemCapacity) {
            if (ForgeRegistries.ITEMS.containsKey(filledItemRes) && ForgeRegistries.ITEMS.containsKey(emptyItemRes)) {
                Item filled = (Item)ForgeRegistries.ITEMS.getValue(filledItemRes);
                Item empty = (Item)ForgeRegistries.ITEMS.getValue(emptyItemRes);
                if (filled != null && empty != null) {
                    this.containerItem(filled, empty, itemCapacity);
                }
            }
            return this;
        }

        public final Builder containerItem(String filledItemRes, String emptyItemRes, int itemCapacity) {
            return this.containerItem(new ResourceLocation(filledItemRes), new ResourceLocation(emptyItemRes), itemCapacity);
        }

        public final Builder emptyHandContainerItem(Item filledItem, int itemCapacity) {
            if (filledItem != Items.field_190931_a) {
                return this.containerItem(filledItem, Items.field_190931_a, itemCapacity);
            }
            return this;
        }

        public final Builder emptyHandContainerItem(ResourceLocation filledItemRes, int itemCapacity) {
            return this.containerItem(filledItemRes, new ResourceLocation("minecraft:air"), itemCapacity);
        }

        public final Builder emptyHandContainerItem(String filledItemRes, int itemCapacity) {
            return this.containerItem(filledItemRes, "minecraft:air", itemCapacity);
        }

        public final Builder bottle(Item item) {
            this.containerItem(item, Items.field_151069_bo, 1);
            return this;
        }

        public final Builder bottle(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bottle(i);
            }
            return this;
        }

        public final Builder bottle(String res) {
            return this.bottle(new ResourceLocation(res));
        }

        public final Builder drink(Item item) {
            return this.bottle(item).food(item, 1);
        }

        public final Builder drink(String res) {
            return this.bottle(res).food(res, 1);
        }

        public final Builder bucket(Item item) {
            if (item != Items.field_190931_a) {
                Item i = Items.field_151133_ar;
                FilledContainerCategory c = this.filledContainers.computeIfAbsent(i, s -> new FilledContainerCategory(4, SoundEvents.field_187630_M, SoundEvents.field_187624_K));
                c.addItem(item);
            }
            return this;
        }

        public final Builder bucket(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bucket(i);
            }
            return this;
        }

        public final Builder bucket(String res) {
            return this.bucket(new ResourceLocation(res));
        }

        public final Builder bowl(Item item) {
            this.containerItem(item, Items.field_151054_z, 2);
            return this;
        }

        public final Builder bowl(ResourceLocation itemRes) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(itemRes) && (i = (Item)ForgeRegistries.ITEMS.getValue(itemRes)) != null) {
                this.bowl(i);
            }
            return this;
        }

        public final Builder bowl(String res) {
            return this.bowl(new ResourceLocation(res));
        }

        public final Builder stew(Item item) {
            return this.bowl(item).food(item, 2);
        }

        public final Builder stew(String res) {
            return this.bowl(res).food(res, 2);
        }

        public final Builder setSoundsForCategory(SoundEvent fill, SoundEvent empty, Item emptyContainer) {
            FilledContainerCategory c = this.filledContainers.get(emptyContainer);
            if (c != null) {
                c.setSounds(fill, empty);
            }
            return this;
        }

        public final Builder setBucketSounds(SoundEvent fill, SoundEvent empty) {
            return this.setSoundsForCategory(fill, empty, Items.field_151133_ar);
        }

        public final Builder food(Item item) {
            return this.food(item, 1);
        }

        public final Builder food(ResourceLocation itemRes) {
            return this.food(itemRes, 1);
        }

        public final Builder food(String res) {
            return this.food(res, 1);
        }

        public final Builder food(Item item, int foodDivider) {
            if (item != null && item != Items.field_190931_a) {
                this.foodDivider = foodDivider;
            }
            this.foodItem = item;
            return this;
        }

        public final Builder food(ResourceLocation res, int foodDivider) {
            Item i;
            if (ForgeRegistries.ITEMS.containsKey(res) && (i = (Item)ForgeRegistries.ITEMS.getValue(res)) != null) {
                this.food(i, foodDivider);
            }
            return this;
        }

        public final Builder food(String res, int foodDivider) {
            return this.food(new ResourceLocation(res), foodDivider);
        }
    }
}

